set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2323',
      '21144020',
      79.583261,
      73.591567,
      '4022111',
      8.671455,
      0,
      1.494434,
      0,
      '341442',
      5.304894,
      ' 8-28-1996',
      46,
      65.408187,
      NULL,
      NULL,
      1,
      NULL,
      1.900326,
      NULL,
      1.459132,
      0,
      3,
      1.291929,
      0,
      0.445002,
      8.866950,
      NULL,
      6.877222,
      3.098748,
      0,
      0.098201,
      2.378392,
      1,
      1.340395,
      0,
      7,
      1,
      3,
      0,
      0.530437,
      5,
      2,
      0,
      NULL,
      NULL,
      2,
      4,
      4.458886,
      11.755294,
      NULL,
      NULL,
      3.563324,
      1.303342,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      1.448189,
      2,
      3.508051,
      0,
      0,
      3,
      0,
      1.038932,
      3.772182,
      NULL,
      1.850187,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.874861,
      4,
      1.140324,
      0.533468,
      5,
      0.836408,
      1.639648,
      4,
      1.891213,
      1.765305,
      1,
      1,
      0.069420,
      NULL,
      0,
      1.717485,
      1,
      NULL,
      0,
      1.521942,
      1.784927,
      NULL,
      NULL,
      5.958507,
      0,
      0.469354,
      4.982469,
      1,
      NULL,
      1.631465,
      NULL,
      NULL,
      1,
      7,
      3,
      NULL,
      0.437206,
      1,
      0.566732,
      6.946989,
      11.309175,
      NULL,
      NULL,
      1.793733,
      7,
      NULL,
      2.513945,
      NULL,
      7,
      5,
      9.434779,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938667,
      0,
      NULL,
      0,
      NULL,
      4,
      5.848443,
      0.129688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.979408,
      NULL,
      0.614679,
      0.742817,
      1,
      2.249391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.106166,
      NULL,
      NULL,
      NULL,
      NULL,
      5.955824,
      1,
      NULL,
      7,
      3.493472,
      2,
      6.143673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.703936,
      3,
      NULL,
      2.281095,
      3,
      0.175973,
      NULL,
      1.716012,
      3.661815,
      NULL,
      0,
      0,
      3.759086,
      NULL,
      NULL,
      3,
      2.652054,
      NULL,
      1.174947,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.815858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.182441,
      NULL,
      '30000',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      4.771876,
      1,
      1,
      1,
      0.739307,
      0.382605,
      1,
      1,
      NULL);
commit;
end;
/


