set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4042',
      '31112214',
      NULL,
      72,
      '2320123',
      311.564226,
      1,
      NULL,
      0,
      '002043',
      0.374600,
      '10- 0-1993',
      56.780095,
      52.512607,
      1.296737,
      NULL,
      NULL,
      0.962148,
      0,
      1,
      0,
      1,
      1,
      0,
      3.633893,
      1.523000,
      NULL,
      1.697273,
      1.344319,
      1.339853,
      NULL,
      1,
      1.426867,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.129548,
      1.645998,
      1,
      NULL,
      0,
      NULL,
      2.028522,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1.406405,
      NULL,
      NULL,
      NULL,
      0.254787,
      1.530152,
      1.632787,
      0.533742,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.459180,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.634816,
      0.039247,
      0.307217,
      NULL,
      1,
      0.984263,
      0.266158,
      NULL,
      1,
      0.983590,
      NULL,
      1.967586,
      1,
      1,
      0,
      1.159236,
      NULL,
      1.452687,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      3.969875,
      0,
      4.120213,
      2.081344,
      0,
      1,
      5,
      1.512974,
      NULL,
      5.533606,
      5,
      4.509047,
      NULL,
      0.088944,
      5.557341,
      3.303570,
      0.470612,
      3.036843,
      5,
      2,
      1.244694,
      NULL,
      NULL,
      0.352119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791776,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.731424,
      NULL,
      1.681930,
      NULL,
      3.893997,
      0.448495,
      1,
      1.237127,
      1,
      0.903374,
      0.330630,
      4.081940,
      2.804142,
      1.928613,
      NULL,
      NULL,
      NULL,
      1.117313,
      0.028510,
      6,
      5,
      0,
      NULL,
      0.498540,
      NULL,
      NULL,
      NULL,
      1,
      4.686371,
      0.430150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.247396,
      1,
      0,
      3,
      1.945532,
      0.465903,
      1,
      1,
      0.704769,
      1.176821,
      NULL,
      0,
      0,
      1.033521,
      1.935901,
      1.834578,
      1,
      0.037033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.252157,
      '41140',
      '44220',
      NULL,
      0,
      '',
      '',
      NULL,
      1.058867,
      '',
      '',
      NULL,
      NULL,
      5.478851,
      3.374350,
      1,
      3,
      0.538652,
      NULL,
      2.115847,
      3.454296);
commit;
end;
/


