set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4411',
      '43324044',
      47,
      59,
      NULL,
      352,
      1,
      1.241209,
      3,
      '141222',
      NULL,
      ' 1-19-2001',
      44.343938,
      NULL,
      NULL,
      NULL,
      1.616455,
      NULL,
      1.772586,
      0.915227,
      NULL,
      1.990193,
      NULL,
      1,
      1,
      NULL,
      2,
      1.301727,
      0.158029,
      0,
      0,
      1.514281,
      3,
      0.766078,
      NULL,
      1,
      1,
      1.624628,
      2,
      1,
      NULL,
      0,
      0.545699,
      0.955799,
      NULL,
      NULL,
      0.281554,
      NULL,
      NULL,
      5,
      0.168796,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.034087,
      1,
      NULL,
      0,
      0,
      0.954142,
      3,
      0,
      0,
      1,
      0.629177,
      0.364970,
      NULL,
      3.809373,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.311874,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.053230,
      0.866549,
      NULL,
      0,
      0,
      0,
      0.998590,
      NULL,
      NULL,
      1.842264,
      NULL,
      1,
      1,
      NULL,
      1,
      0.565247,
      1.218727,
      NULL,
      0.585352,
      4.680557,
      5.605281,
      2.107639,
      0.435235,
      1.164182,
      1,
      7,
      1,
      1.746431,
      4.732938,
      8,
      2,
      5,
      6,
      3.045308,
      7,
      5.744128,
      4.552952,
      1.638819,
      4.898503,
      1,
      NULL,
      NULL,
      1.892087,
      0.895451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.165539,
      1,
      0,
      1.144852,
      NULL,
      0.961398,
      0.901140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.576874,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.034924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.493219,
      1.885712,
      1.158224,
      3.955599,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643083,
      0.546559,
      2,
      0,
      NULL,
      1.503089,
      1,
      2.659108,
      1,
      NULL,
      1,
      1.605164,
      NULL,
      0.708101,
      1,
      1,
      NULL,
      0.710171,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '10424',
      '13241',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.740488,
      NULL,
      3,
      3.408660,
      3,
      0,
      1.137025,
      NULL,
      NULL);
commit;
end;
/


