set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0304',
      '34213033',
      67,
      18,
      NULL,
      247.503722,
      1,
      2,
      3,
      '231011',
      4.763650,
      ' 7-20-1979',
      21,
      NULL,
      1.191491,
      NULL,
      1.912609,
      2.760262,
      1.149654,
      0.206380,
      0.571984,
      0.960412,
      0,
      1,
      0,
      0,
      1,
      0,
      1.869415,
      2,
      1,
      0,
      5,
      1.498388,
      NULL,
      0.121207,
      NULL,
      0,
      3.474892,
      1,
      2,
      1.057892,
      1.312960,
      1.697380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.567819,
      1,
      1.889856,
      1,
      1.067381,
      3.571336,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0.426002,
      1.662466,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0.252797,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242979,
      0,
      NULL,
      1.605623,
      0.982707,
      0.563194,
      1,
      1.737387,
      0.010596,
      NULL,
      0.591779,
      1,
      1.259598,
      0,
      0.413537,
      NULL,
      0,
      0.311040,
      0.880706,
      NULL,
      0.702595,
      0,
      0.593941,
      0.966550,
      NULL,
      1,
      1.474224,
      NULL,
      4.441323,
      4,
      3,
      5.565277,
      1,
      1.039807,
      6.891527,
      0.459076,
      1.261351,
      6,
      7.535713,
      7,
      8,
      10.525853,
      0.462048,
      0,
      2.306265,
      0.901278,
      1.451371,
      3,
      1,
      NULL,
      NULL,
      0.149281,
      1.510201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0.094699,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425343,
      NULL,
      NULL,
      3.218074,
      1.948644,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.039009,
      2.151508,
      1.634377,
      NULL,
      NULL,
      NULL,
      5.727981,
      1,
      NULL,
      1,
      1,
      2,
      0.375838,
      1.079891,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012014,
      2.866715,
      1.425074,
      1,
      1,
      0,
      NULL,
      0.096521,
      1,
      3,
      1.066423,
      NULL,
      1.359701,
      NULL,
      1,
      1,
      NULL,
      0.367216,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41430',
      '40004',
      '',
      1.743784,
      NULL,
      '',
      '',
      3,
      '2220',
      NULL,
      NULL,
      4,
      0,
      2.967168,
      3.299690,
      2,
      0.842197,
      1.633453,
      0.287025,
      1.197975);
commit;
end;
/


