set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '004',
      NULL,
      33.719866,
      13,
      NULL,
      NULL,
      6,
      3.450640,
      1,
      '043100',
      4.484181,
      ' 9- 7-1976',
      17.607354,
      19,
      1.635741,
      NULL,
      1.831006,
      1,
      1,
      1,
      1,
      1,
      0.704112,
      0,
      1,
      NULL,
      1.350189,
      1.779151,
      0,
      8.988805,
      1.653047,
      1.298478,
      4.172558,
      NULL,
      1.088274,
      0,
      NULL,
      0.179499,
      7.618650,
      NULL,
      1.966425,
      1.955531,
      0,
      1.033313,
      NULL,
      NULL,
      1.417346,
      NULL,
      NULL,
      NULL,
      0.348569,
      1,
      0.364281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.824551,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.192958,
      0,
      1,
      2,
      0.745094,
      5.894108,
      1,
      0.118997,
      0,
      NULL,
      1,
      NULL,
      0.422084,
      1.166493,
      0.535209,
      NULL,
      1,
      0,
      NULL,
      0.576501,
      1,
      2,
      1,
      0.811601,
      1.358290,
      0.760781,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547254,
      0,
      2,
      1.478622,
      1,
      NULL,
      1,
      5.834410,
      7,
      NULL,
      NULL,
      NULL,
      6,
      1.571376,
      0.381738,
      NULL,
      3.357106,
      0.118531,
      NULL,
      NULL,
      0.114108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279883,
      NULL,
      1,
      NULL,
      0.652021,
      1.256267,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202111,
      NULL,
      0,
      0.398596,
      0,
      NULL,
      1.444860,
      NULL,
      NULL,
      NULL,
      1.401919,
      0.562592,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.983130,
      2,
      0.039531,
      0,
      NULL,
      2.387883,
      1,
      NULL,
      1,
      3.191796,
      1,
      0,
      NULL,
      NULL,
      0.671098,
      1.877343,
      0.072995,
      0,
      0.324974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001133,
      '43010',
      '',
      NULL,
      0.637269,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.267043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


