set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '41',
      26.024812,
      10,
      '0104210',
      NULL,
      3,
      1.701490,
      2,
      '410402',
      1.264807,
      '10-18-1979',
      24,
      57,
      NULL,
      NULL,
      0.121706,
      1,
      NULL,
      0.753994,
      1.166703,
      1,
      NULL,
      0,
      1,
      1,
      4.106972,
      1.383816,
      1.494838,
      NULL,
      4.583526,
      NULL,
      NULL,
      0,
      NULL,
      0.490128,
      NULL,
      0.699817,
      5.501291,
      1,
      2.550445,
      NULL,
      0,
      0.253721,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.885288,
      0.338709,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.730142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081311,
      5,
      3.912227,
      0.575749,
      4,
      6.475347,
      7.687188,
      0,
      0,
      3.360231,
      NULL,
      NULL,
      1,
      0,
      0,
      0.299052,
      0.498458,
      1.508136,
      1,
      NULL,
      0.936452,
      0,
      0,
      1.605316,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.257167,
      4.681366,
      NULL,
      2.796017,
      0.495603,
      1,
      1.699553,
      0.185262,
      2.638242,
      5,
      8.613690,
      9.439991,
      NULL,
      NULL,
      3.518776,
      2.751590,
      2,
      1.200479,
      0.835493,
      0.300662,
      1.763951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725082,
      0.057325,
      1,
      1,
      0,
      1,
      1.899566,
      1.439678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.838658,
      0,
      0.269075,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      0,
      0,
      1,
      0.026922,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.654452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.016936,
      1,
      1,
      0.459516,
      2.395140,
      0,
      NULL,
      0,
      1,
      1.612649,
      1,
      0.260901,
      1.695097,
      NULL,
      0.205244,
      NULL,
      0,
      1.789385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      4.159800,
      NULL,
      3.273800,
      2,
      1,
      1,
      NULL,
      7,
      2.876898);
commit;
end;
/


