set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '20430244',
      20.028350,
      NULL,
      '2313320',
      22,
      3,
      1.002538,
      2,
      '443304',
      3.752120,
      NULL,
      NULL,
      50,
      NULL,
      NULL,
      NULL,
      0.585179,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.614520,
      1,
      4,
      1.530086,
      0,
      NULL,
      NULL,
      2.961319,
      0,
      0.042090,
      1,
      1,
      0,
      0.069234,
      2,
      NULL,
      0,
      2.497471,
      1.945425,
      0,
      NULL,
      NULL,
      1.129037,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.848908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568295,
      5,
      NULL,
      NULL,
      5,
      0,
      2,
      1,
      4.163942,
      4.123884,
      1.651537,
      1,
      0,
      3.892877,
      0.802849,
      0,
      0,
      0,
      NULL,
      NULL,
      1.394317,
      0.311652,
      1.719616,
      0.949477,
      1,
      NULL,
      1,
      2.511133,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.195428,
      5.934096,
      3.619579,
      NULL,
      1,
      1.822046,
      6,
      3,
      6.936025,
      6.214929,
      0.175350,
      3,
      1.276059,
      5.841524,
      2.053102,
      0,
      1,
      NULL,
      2.342688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1.025724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825693,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.078224,
      NULL,
      NULL,
      NULL,
      1.581457,
      0.821254,
      3.506708,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.367182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.115685,
      0,
      2.313755,
      1.116245,
      0,
      2.376176,
      0.142658,
      NULL,
      1.141068,
      3.694015,
      3.397939,
      0,
      0.480110,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.424100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.589820,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.939631,
      1,
      0,
      0,
      3.950370,
      '24332',
      NULL,
      '',
      1.546576,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      5.455239,
      NULL,
      3,
      0,
      1,
      2.330873,
      1.929963,
      NULL,
      0);
commit;
end;
/


