set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31323314',
      67.313353,
      19,
      NULL,
      80,
      3,
      3,
      0,
      '110344',
      4,
      ' 2- 7-1989',
      NULL,
      7,
      1,
      NULL,
      1.544033,
      NULL,
      3.714284,
      0,
      0.366080,
      1.630025,
      0,
      1.131277,
      NULL,
      0.215904,
      4.078981,
      NULL,
      1.152167,
      9.509157,
      0,
      1.316729,
      1.757424,
      0.317558,
      1.454005,
      1,
      1,
      1,
      NULL,
      1,
      0.267267,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.849104,
      1.734745,
      1.982221,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626534,
      0,
      NULL,
      0.850611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0,
      2,
      6,
      NULL,
      1.026658,
      NULL,
      3.670437,
      2.879769,
      4,
      1.085390,
      NULL,
      1.233378,
      1,
      1,
      1.756630,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0.799517,
      2,
      3.883145,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      1.282684,
      9.022016,
      3,
      NULL,
      9,
      9.704151,
      NULL,
      2.690837,
      0,
      1.642646,
      0,
      1.508143,
      0.454861,
      0,
      0.107297,
      5.738186,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.375819,
      1,
      1.812561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.778076,
      1,
      NULL,
      0,
      0.920528,
      0,
      3.682817,
      3.719524,
      1.650322,
      NULL,
      NULL,
      NULL,
      0,
      0.531182,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.976913,
      2,
      0.506274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735247,
      2,
      NULL,
      1.224986,
      1.082860,
      NULL,
      NULL,
      3.225940,
      0.877979,
      2,
      0.178863,
      1.365347,
      NULL,
      0,
      1.750495,
      0,
      1,
      0.946565,
      0.373471,
      0.217954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.214887,
      NULL,
      '',
      '',
      0.189611,
      '',
      '',
      '',
      0.077054,
      NULL,
      '',
      '',
      0,
      4.311253,
      2.240778,
      NULL,
      3.004137,
      1,
      3.680930,
      4.655361,
      0.212319);
commit;
end;
/


