set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      NULL,
      75,
      NULL,
      '2221001',
      74.211902,
      6,
      1,
      NULL,
      '303021',
      NULL,
      ' 8-14-1996',
      32,
      NULL,
      1,
      NULL,
      NULL,
      1.997239,
      NULL,
      0.877848,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.961388,
      1,
      NULL,
      2,
      0.834190,
      5.564948,
      0,
      1.303646,
      1,
      0,
      0.862491,
      NULL,
      1,
      NULL,
      0.719588,
      0.061725,
      NULL,
      NULL,
      NULL,
      0.351870,
      NULL,
      NULL,
      0,
      1.087732,
      1,
      1.404910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.723819,
      0.411123,
      1.481736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076671,
      2,
      1,
      NULL,
      0,
      9,
      4,
      0,
      0.012262,
      4.352401,
      7,
      0,
      NULL,
      4.506033,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.369114,
      1,
      2.392750,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.047900,
      4,
      NULL,
      6,
      7.299098,
      1.005848,
      0.386832,
      0,
      8.038703,
      1.419783,
      1,
      NULL,
      3,
      1.574735,
      NULL,
      NULL,
      1.274076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728744,
      1.480505,
      0,
      0,
      1.669750,
      NULL,
      0.314001,
      1.201399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440989,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.866203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.969650,
      0.218632,
      0.840026,
      1.684324,
      0,
      1.041645,
      NULL,
      NULL,
      NULL,
      0.760262,
      1.092841,
      0.206433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0.455659,
      0,
      1.685478,
      0.722871,
      3,
      1,
      1.201319,
      1.077767,
      1,
      0.047847,
      0.354625,
      1,
      1.463631,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      3,
      NULL,
      0.590623,
      1.704296,
      3.777751,
      NULL,
      3,
      1.616656);
commit;
end;
/


