set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      NULL,
      NULL,
      29.258777,
      '0223202',
      102.333967,
      0,
      1.528131,
      1,
      '433320',
      NULL,
      ' 7-29-1981',
      NULL,
      38,
      1.558978,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469866,
      1,
      1,
      1.192493,
      1.960920,
      1.893855,
      1.369132,
      5.198147,
      0.140064,
      1.645062,
      5,
      5,
      0,
      6,
      NULL,
      3,
      0.537260,
      0,
      0,
      7.330387,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.381039,
      3,
      0,
      3,
      NULL,
      1.065580,
      3.986059,
      1.225236,
      2,
      NULL,
      0.370495,
      2,
      0,
      NULL,
      NULL,
      1,
      0.836629,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      3,
      3.596845,
      4.950068,
      1,
      5.624471,
      7,
      0.494433,
      NULL,
      0.379573,
      NULL,
      0.653913,
      0.885436,
      0.714394,
      1.063373,
      1.794032,
      NULL,
      1.460033,
      0.724969,
      3.016171,
      0.518116,
      1.524993,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0.521888,
      1,
      1,
      3,
      2,
      NULL,
      4.374380,
      8,
      0.483875,
      8.704540,
      NULL,
      NULL,
      7.063559,
      1.023841,
      0.757424,
      0,
      0.762167,
      1,
      1.265642,
      2.784187,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0.620721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.770352,
      4.216151,
      1,
      0.110515,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.256565,
      2.239628,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843776,
      3,
      0,
      1,
      0,
      2,
      1.095743,
      1.138692,
      0,
      3,
      3,
      1.999577,
      1,
      1.309539,
      0,
      1,
      0,
      1.086254,
      NULL,
      0.797895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.354285,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      3,
      5,
      1,
      0,
      1,
      2,
      0,
      0.796761,
      2);
commit;
end;
/


