set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '314',
      '44223344',
      65,
      NULL,
      '3230240',
      40,
      5,
      2,
      0,
      NULL,
      NULL,
      '11-12-1994',
      4.881389,
      56,
      0,
      NULL,
      1,
      1.153638,
      2,
      0.518330,
      1,
      0,
      1.827825,
      0.408351,
      0.409591,
      0.851030,
      4,
      1,
      0.837761,
      3,
      2.623485,
      1.337601,
      NULL,
      1.673014,
      3.543467,
      1,
      0.816667,
      NULL,
      4,
      NULL,
      2.977689,
      0,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.743677,
      3,
      1.187917,
      3,
      0.871530,
      1.680050,
      NULL,
      1,
      0.059534,
      0.595573,
      NULL,
      1,
      0,
      1.061990,
      0.077368,
      0.608740,
      0.145368,
      0,
      3.314072,
      1.661659,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.206742,
      1.413424,
      1,
      NULL,
      0,
      7.060043,
      0.237471,
      NULL,
      6,
      3,
      1,
      0,
      3,
      1,
      NULL,
      1.664434,
      0.607261,
      1,
      NULL,
      NULL,
      0.213325,
      0,
      1,
      1.986842,
      5,
      4,
      1.540578,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860550,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.901099,
      6,
      1,
      3.652251,
      9.800400,
      3,
      5,
      0,
      0,
      1,
      3,
      NULL,
      1.072518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339462,
      1.492605,
      0,
      2,
      NULL,
      1,
      0.764371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.837727,
      1.041073,
      0.142202,
      NULL,
      NULL,
      NULL,
      1.074233,
      1,
      5,
      1.725168,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.872124,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      0.326781,
      2.642771,
      3,
      1.702376,
      0.782443,
      0,
      0,
      NULL,
      1.442693,
      0.327089,
      0.971563,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.531419,
      '03203',
      '',
      NULL,
      0.284677,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      4.721328,
      2,
      3.387532,
      0,
      2.924849,
      0,
      1,
      2.937050,
      1.259926);
commit;
end;
/


