set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03231113',
      NULL,
      1,
      '2412420',
      144,
      5,
      2,
      NULL,
      '204421',
      NULL,
      ' 4- 2-1981',
      62,
      159,
      0.125055,
      NULL,
      1,
      NULL,
      3.968026,
      NULL,
      1.940922,
      0,
      NULL,
      2,
      1.064874,
      NULL,
      6,
      NULL,
      1.250327,
      0.049692,
      0.476131,
      NULL,
      4,
      1,
      1.792156,
      1,
      1.543541,
      0,
      2.212316,
      0,
      2,
      4.507420,
      2,
      1.755812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.489181,
      1.305267,
      1.179073,
      1,
      1.204838,
      1.122276,
      1.254993,
      NULL,
      NULL,
      3,
      1,
      0.878407,
      1,
      1.309959,
      0,
      NULL,
      0,
      2,
      3.643179,
      0,
      NULL,
      3.889138,
      0.385641,
      NULL,
      NULL,
      1.161388,
      NULL,
      NULL,
      0.095283,
      NULL,
      1,
      NULL,
      4.318196,
      5.128708,
      3.123855,
      1.715904,
      1.729873,
      NULL,
      NULL,
      NULL,
      1.165833,
      1.322081,
      0,
      0,
      0.752243,
      NULL,
      1,
      NULL,
      0.785034,
      0.431056,
      1.177993,
      0.865085,
      1,
      NULL,
      3,
      2.945760,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360828,
      0,
      1.165982,
      5.644378,
      1,
      NULL,
      NULL,
      8.176534,
      7.193984,
      7.053902,
      NULL,
      5.117573,
      1,
      1.711504,
      0.099268,
      1,
      0.451591,
      1.217408,
      1.490951,
      NULL,
      1.249713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.346729,
      1,
      0,
      1.967648,
      NULL,
      1.521472,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480650,
      3,
      NULL,
      0,
      0,
      0.685691,
      NULL,
      NULL,
      NULL,
      1.798840,
      1,
      0.625198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      0,
      NULL,
      3.249379,
      1,
      NULL,
      0,
      3.234119,
      0.477161,
      0,
      0.944441,
      0,
      0.579530,
      1.340037,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227843,
      '33101',
      NULL,
      '',
      1.652856,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      4,
      5,
      NULL,
      3.282773,
      NULL,
      NULL,
      NULL,
      3,
      1);
commit;
end;
/


