set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2010',
      '02112141',
      80,
      40.051382,
      '1132311',
      101.036467,
      6,
      3,
      3,
      '023011',
      NULL,
      ' 8- 8-1986',
      23.082026,
      10.266849,
      NULL,
      NULL,
      1.553312,
      0,
      3.997089,
      1.665973,
      0.601269,
      1,
      NULL,
      2,
      0.814403,
      NULL,
      1,
      1.109879,
      1.426779,
      2,
      0,
      NULL,
      6,
      1,
      1.765412,
      1,
      1,
      0.683822,
      0.744916,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328761,
      NULL,
      NULL,
      6.715027,
      NULL,
      NULL,
      1,
      NULL,
      1.225179,
      NULL,
      NULL,
      2.405372,
      3,
      0.758725,
      3.827779,
      1.574146,
      0,
      1.597872,
      1.568672,
      2,
      3.475409,
      2.791412,
      0,
      0.062860,
      0,
      4.489595,
      NULL,
      NULL,
      NULL,
      1.011872,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      4.982126,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      4,
      1.401268,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0.987320,
      0.322346,
      0,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.835075,
      1.045914,
      3,
      3.872634,
      NULL,
      2.108671,
      0,
      0,
      6,
      6.599005,
      NULL,
      2.290625,
      NULL,
      0.849508,
      0.908448,
      NULL,
      2.589600,
      NULL,
      0.706906,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.626496,
      NULL,
      0,
      0.025653,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980168,
      NULL,
      0.761586,
      2.499920,
      NULL,
      1.639042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.720577,
      1,
      6,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3.707116,
      2,
      1,
      1.637456,
      NULL,
      0,
      0.327897,
      1.829455,
      NULL,
      1,
      0,
      1,
      1,
      1.180025,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '30410',
      '',
      '',
      1.905374,
      '',
      '',
      '',
      1.509396,
      '',
      '',
      '',
      5.598368,
      0,
      3,
      NULL,
      2,
      NULL,
      2,
      3,
      NULL);
commit;
end;
/


