set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '222',
      '23342014',
      50.614109,
      45.158564,
      NULL,
      19.435573,
      NULL,
      2.947434,
      2,
      '040403',
      5,
      '10- 0-1996',
      91.853399,
      77,
      1,
      NULL,
      1.056070,
      1.772471,
      0,
      1.540067,
      NULL,
      1,
      0.407192,
      1,
      NULL,
      0.955774,
      NULL,
      1.751845,
      0.179318,
      0,
      1,
      1.416366,
      NULL,
      0.636490,
      1,
      NULL,
      1.594857,
      1,
      6,
      0,
      3.116089,
      NULL,
      NULL,
      1.755029,
      NULL,
      NULL,
      0.939613,
      NULL,
      NULL,
      3,
      NULL,
      1.734332,
      1.942781,
      NULL,
      0.721931,
      1,
      1.947979,
      0,
      3.501903,
      NULL,
      NULL,
      NULL,
      0.357056,
      0,
      0.224869,
      3,
      2.476050,
      3.136484,
      1,
      0,
      0.357745,
      0,
      NULL,
      2,
      1.074660,
      1,
      NULL,
      NULL,
      0.428715,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.705603,
      2,
      NULL,
      3,
      1,
      1,
      0,
      1.195102,
      1,
      0,
      2,
      1,
      1.529543,
      1,
      0.059395,
      0,
      NULL,
      1.751811,
      1.660863,
      3,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.733361,
      NULL,
      NULL,
      1,
      0.103067,
      4,
      2,
      9.029165,
      0,
      NULL,
      2.303184,
      1,
      1,
      2.342750,
      2.124532,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593317,
      1,
      NULL,
      0,
      1.311587,
      2,
      0.027105,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.179972,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.302877,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159449,
      2,
      NULL,
      3.701742,
      1,
      0.398500,
      3,
      0.393867,
      1.940660,
      2.357775,
      NULL,
      1,
      NULL,
      1.218697,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '11414',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.357715,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3.159743,
      1,
      2.114071);
commit;
end;
/


