set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04110114',
      NULL,
      14.700732,
      '3213033',
      59.078465,
      0,
      1.809379,
      1,
      '434400',
      4.394533,
      ' 1- 3-1976',
      8,
      NULL,
      1.318307,
      NULL,
      1,
      0,
      NULL,
      3.731391,
      1,
      NULL,
      0.048914,
      2.620418,
      NULL,
      1.462589,
      2,
      1.025068,
      0.130983,
      1,
      0.848363,
      0.453615,
      1,
      0,
      1,
      1.303127,
      NULL,
      1.377528,
      2.553403,
      NULL,
      0,
      1,
      1.907982,
      0.570670,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.740611,
      1.652306,
      NULL,
      0.102921,
      0.741055,
      0.062500,
      NULL,
      0.628176,
      0,
      2.354155,
      0,
      1,
      NULL,
      0.933767,
      2.319823,
      0,
      3,
      2,
      NULL,
      0.272256,
      1,
      0.331603,
      2,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.152437,
      NULL,
      NULL,
      0.017494,
      1.365686,
      0,
      NULL,
      1,
      1.351075,
      NULL,
      0,
      0,
      0.635023,
      1,
      0,
      1.890089,
      1.669146,
      1.335171,
      0.690451,
      1,
      0.294903,
      1.422512,
      NULL,
      0.927014,
      1.045720,
      5.266712,
      1.791101,
      NULL,
      0.871640,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.733684,
      0,
      NULL,
      1,
      1.114103,
      1,
      4,
      1,
      1.901923,
      1,
      0.459118,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.714944,
      0.731701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289848,
      0.418655,
      1,
      0,
      1,
      0.555848,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.148488,
      NULL,
      0,
      1.225324,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1.817259,
      0,
      0,
      0.000719,
      2.816957,
      NULL,
      0.774124,
      NULL,
      1,
      0.242035,
      1.119096,
      NULL,
      1.207555,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11040',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      3.790756,
      1,
      NULL,
      NULL,
      2.359962,
      2.791904,
      NULL,
      NULL,
      NULL);
commit;
end;
/


