set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0333',
      '13213430',
      21.892286,
      38,
      '3244223',
      4.169566,
      NULL,
      0.649809,
      3,
      '422133',
      2,
      ' 7-26-1974',
      18,
      97,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      0.128790,
      3,
      1.466715,
      0.309768,
      NULL,
      0,
      1,
      3,
      0.580104,
      0.066366,
      0.339599,
      1,
      NULL,
      5.650248,
      0,
      NULL,
      1.833012,
      1.545434,
      0.078539,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.045435,
      1.377857,
      1,
      NULL,
      0,
      0.205095,
      3,
      0,
      1,
      NULL,
      1.878915,
      1,
      1.336520,
      1,
      0,
      NULL,
      3,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      0.512038,
      NULL,
      NULL,
      NULL,
      1.362128,
      1.492486,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.162966,
      1.409873,
      NULL,
      1,
      1.679780,
      0,
      1,
      NULL,
      NULL,
      0.299887,
      1,
      NULL,
      1.645249,
      0.921434,
      1,
      0.545978,
      0,
      NULL,
      0.191238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.540590,
      NULL,
      1.595360,
      NULL,
      1,
      1.981226,
      2,
      0,
      0.975258,
      NULL,
      0.647401,
      0.174410,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      7,
      1.184289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.067741,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390702,
      0.163086,
      1.997794,
      1.372588,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.739738,
      0,
      1.515440,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.822325,
      NULL,
      0.962651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.090158,
      1.748486,
      0,
      1.910547,
      NULL,
      0,
      0.426804,
      1,
      1,
      0.756127,
      1.552970,
      0,
      1.069286,
      1,
      NULL,
      0.555027,
      1.847303,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.865967,
      '',
      '',
      '',
      NULL,
      0,
      2.621824,
      3.100722,
      NULL,
      0.633563,
      NULL,
      2,
      2);
commit;
end;
/


