set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4121',
      '04301304',
      22,
      59,
      '2420334',
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      ' 6- 3-1984',
      NULL,
      NULL,
      0.604515,
      NULL,
      1.549376,
      NULL,
      NULL,
      1.748525,
      NULL,
      1.929891,
      0.203934,
      2,
      NULL,
      0.294228,
      1.030760,
      NULL,
      1,
      0.829364,
      1,
      0,
      1,
      0,
      1,
      0.327354,
      0,
      1.493618,
      1,
      0,
      2.349060,
      1.158543,
      1,
      NULL,
      NULL,
      NULL,
      1.846925,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1.327015,
      0,
      1,
      1.467082,
      0.863283,
      2.566908,
      0,
      0,
      NULL,
      2.428391,
      1,
      1.857855,
      2,
      0,
      1,
      1.631141,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989066,
      0.890563,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.136957,
      0.581970,
      0,
      0.489771,
      0.376360,
      0.043334,
      1,
      NULL,
      0.868528,
      0.690908,
      1.327162,
      NULL,
      1,
      0,
      NULL,
      0.479258,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      0,
      1,
      1.048079,
      1.300155,
      4.969852,
      NULL,
      1,
      0.522446,
      0,
      0.776246,
      3,
      0,
      3.669029,
      NULL,
      NULL,
      NULL,
      6.751202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0.147897,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490671,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      0.253517,
      0,
      1,
      3.899602,
      1.477545,
      0,
      2,
      1,
      0.835289,
      0,
      1.680625,
      NULL,
      0.219658,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.591684,
      NULL,
      '',
      '',
      2,
      0.140481,
      2.974855,
      0.281789,
      0.823131,
      NULL,
      0,
      2.256652,
      1);
commit;
end;
/


