set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12004114',
      42.394152,
      2.095260,
      '1203131',
      120,
      0,
      NULL,
      2,
      '242331',
      4.183346,
      NULL,
      120,
      31,
      0,
      NULL,
      1,
      1,
      NULL,
      0.890993,
      1,
      1.789387,
      0.294419,
      NULL,
      1,
      0,
      2.387160,
      0.477271,
      0,
      0.921853,
      0.043543,
      NULL,
      0,
      1.374884,
      0.954142,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0.549624,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.868229,
      3,
      0.110435,
      1.211145,
      0,
      1.417900,
      1,
      0,
      0,
      0.912800,
      1.432957,
      0.351337,
      1,
      2.414566,
      3.140467,
      NULL,
      0,
      0.632445,
      1,
      1,
      0.779581,
      0,
      2.361604,
      1,
      NULL,
      1.896303,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.020959,
      NULL,
      0,
      0.497690,
      0,
      1,
      NULL,
      0.273646,
      1,
      0.049351,
      NULL,
      1,
      1.636951,
      1.751209,
      1.674056,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      3.831144,
      1.436791,
      0.467057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.197325,
      2.841133,
      NULL,
      1,
      1,
      0.712985,
      NULL,
      0.153117,
      NULL,
      1,
      0.336063,
      0,
      NULL,
      NULL,
      NULL,
      0.817477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0.160703,
      0.057864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385693,
      0.443146,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091999,
      0.260604,
      1.768080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433610,
      0,
      NULL,
      0,
      1.171003,
      3.572398,
      0.848564,
      NULL,
      0.688161,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      1.407584,
      1,
      0,
      1.469571,
      1.923321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.729996,
      NULL,
      NULL,
      '',
      1.474963,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.374153,
      1,
      2.911724,
      1.406499,
      0.451721,
      0.667981,
      0,
      1.882345,
      2.224196);
commit;
end;
/


