set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1222',
      '20431434',
      82,
      NULL,
      '4403114',
      116,
      4,
      NULL,
      0,
      '431020',
      4,
      '10-10-2001',
      NULL,
      45,
      1,
      NULL,
      1.012632,
      NULL,
      1.959735,
      NULL,
      0.902836,
      0.454781,
      1.988285,
      2.095864,
      NULL,
      1.334526,
      0.292453,
      NULL,
      0.547564,
      1.905146,
      1.114426,
      0,
      0.766490,
      0,
      0,
      0.268730,
      NULL,
      NULL,
      5.863527,
      1,
      2,
      NULL,
      0.633921,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.117796,
      NULL,
      NULL,
      1.552436,
      0,
      1.359711,
      2.674632,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.819434,
      0.487127,
      1,
      1.452301,
      NULL,
      1.144073,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.412808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713774,
      0,
      1.874173,
      0.501996,
      1.371843,
      NULL,
      0,
      1.641764,
      0,
      1,
      0,
      1.500943,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1.963164,
      0.882028,
      5,
      2.341395,
      1.072881,
      0.698792,
      1.094436,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820606,
      2,
      0,
      0.788146,
      0,
      3.327259,
      5.123416,
      NULL,
      0.580204,
      1.057586,
      NULL,
      NULL,
      NULL,
      0.848572,
      0.451120,
      NULL,
      0,
      NULL,
      NULL,
      1.521118,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.939443,
      NULL,
      0,
      NULL,
      1.580718,
      1,
      0.669679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.313292,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.317932,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.932540,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.421288,
      2.113923,
      2.136959,
      1.452537,
      1.378098,
      NULL,
      3,
      0,
      0,
      3.537325,
      1,
      NULL,
      NULL,
      NULL,
      0.614857,
      NULL,
      0,
      1.369383,
      0.101369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '23304',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      5.413411,
      3,
      3,
      3,
      1,
      0.428055,
      3,
      0.893359,
      3);
commit;
end;
/


