set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '34421104',
      35.876203,
      NULL,
      '4403433',
      NULL,
      1,
      0.948754,
      2,
      '412112',
      1.409588,
      '11- 3-1980',
      NULL,
      NULL,
      0.360450,
      NULL,
      2.967122,
      1,
      NULL,
      0.990977,
      0.696972,
      0.161355,
      0,
      NULL,
      0.654527,
      NULL,
      1.163940,
      NULL,
      NULL,
      0.604946,
      1,
      0.992673,
      1.404709,
      1.955798,
      1,
      1,
      0.972899,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097847,
      0,
      0.043414,
      0.845441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477649,
      1.587559,
      0.042675,
      0.054577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.894403,
      0.338430,
      1,
      0.488401,
      1,
      0.981869,
      0,
      1.794064,
      1,
      0,
      0,
      1,
      NULL,
      0.374339,
      1.213143,
      NULL,
      NULL,
      NULL,
      1,
      0.444227,
      1.576124,
      0,
      NULL,
      NULL,
      0.368629,
      0,
      0.248794,
      1,
      0.029598,
      NULL,
      0.587882,
      0,
      0.099986,
      1,
      1,
      4.622852,
      0.034999,
      4,
      4,
      3,
      5,
      NULL,
      6,
      2.369378,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5.949789,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.161087,
      1,
      1,
      NULL,
      NULL,
      0.148705,
      0.896967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738195,
      NULL,
      3.440930,
      1,
      5,
      NULL,
      3.708761,
      0.903399,
      NULL,
      NULL,
      NULL,
      2.624248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.276853,
      0.262972,
      0.429415,
      0.326324,
      NULL,
      1.653097,
      NULL,
      1.321349,
      0,
      NULL,
      0.038829,
      0.183549,
      NULL,
      0,
      0,
      0,
      0.046948,
      0.945594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '13011',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.282089,
      '',
      '',
      '',
      2.580101,
      4.193616,
      2.616408,
      0,
      3,
      1,
      3,
      NULL,
      3);
commit;
end;
/


