set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      '14221401',
      53,
      NULL,
      NULL,
      81.583004,
      1,
      3.915814,
      1,
      NULL,
      1.164760,
      NULL,
      NULL,
      NULL,
      1.726288,
      NULL,
      0.108283,
      1,
      NULL,
      1.362873,
      0.635704,
      1.791444,
      1,
      0,
      NULL,
      1.176675,
      0.962639,
      0.079159,
      NULL,
      NULL,
      0.555558,
      0,
      0,
      1.760039,
      1.589747,
      0.271146,
      1.916326,
      1.488034,
      0.063756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.764142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971687,
      0,
      0.889917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040354,
      NULL,
      0.281032,
      0.826768,
      0.452071,
      NULL,
      0.448399,
      0,
      1.532031,
      0,
      0,
      1.265136,
      0,
      1,
      1,
      0.635511,
      0.108985,
      NULL,
      0.687568,
      NULL,
      1.985850,
      NULL,
      0.427308,
      0.057019,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150064,
      NULL,
      2.898776,
      1.958079,
      0.391300,
      4.428750,
      1.543497,
      3,
      0.725704,
      7,
      2,
      0.046741,
      2.142237,
      0,
      0,
      1.492715,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137360,
      NULL,
      1,
      0,
      0.217206,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0.541972,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.868484,
      1,
      1.859206,
      NULL,
      NULL,
      NULL,
      0,
      0.269666,
      0.816521,
      NULL,
      0.354413,
      NULL,
      NULL,
      1.466253,
      NULL,
      NULL,
      0.345005,
      0,
      0.603373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047547,
      1.731141,
      0,
      1.358653,
      0.213378,
      1,
      0,
      0,
      1.301981,
      0.670176,
      0,
      1,
      1.910816,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626879,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      5.673409,
      5,
      NULL,
      NULL,
      3.707699,
      NULL,
      3.291004,
      2.175082,
      4.358820);
commit;
end;
/


