set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '102',
      '41141441',
      17,
      61.703304,
      '0024304',
      29,
      3,
      0.893809,
      NULL,
      '044001',
      4,
      ' 5-14-1979',
      17,
      28.622487,
      0.232255,
      NULL,
      1.732840,
      NULL,
      0,
      1.143640,
      NULL,
      1.598320,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.287427,
      3.897591,
      1.697224,
      1,
      0.761960,
      0,
      NULL,
      0.003237,
      0.744292,
      1.737120,
      1.032005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.031038,
      1,
      0.566112,
      2,
      1.043335,
      0.595875,
      NULL,
      1,
      NULL,
      0,
      1.297741,
      0,
      2,
      0.222612,
      1,
      1,
      0.843024,
      0.004840,
      1.808824,
      4.485565,
      1.134358,
      1,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.796694,
      NULL,
      NULL,
      1.922160,
      0,
      0,
      1,
      0,
      0.695013,
      1.802812,
      0,
      0,
      NULL,
      1.218050,
      1,
      0,
      3.099243,
      1,
      0.585874,
      NULL,
      1.148281,
      0.992606,
      NULL,
      1.499887,
      0.328622,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.596673,
      1,
      1.565168,
      NULL,
      3,
      0,
      2,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2.947797,
      NULL,
      0,
      1,
      1,
      1,
      9.217134,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.786512,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.963281,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.225103,
      1,
      3,
      0.117183,
      0,
      0,
      1.328122,
      0.018414,
      3,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514522,
      1,
      0.336153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383904,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      3,
      1,
      0.291819,
      0.848413,
      1.274546,
      NULL,
      1.311731,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13234',
      '',
      '',
      0.352841,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.111039,
      3.275558,
      2.083149,
      5.930475,
      2,
      5,
      0,
      3,
      2);
commit;
end;
/


