set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      NULL,
      65.518909,
      53,
      '4220020',
      140.759326,
      NULL,
      0.462436,
      3,
      '420134',
      NULL,
      ' 3-10-1983',
      31,
      61.652766,
      0.761236,
      NULL,
      1.784839,
      1.915497,
      0.590337,
      1.166460,
      1,
      0.334539,
      1,
      1.489884,
      0.002704,
      0.716592,
      5.603236,
      0.314714,
      1,
      0.009459,
      0.568168,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.874509,
      1.491463,
      7.605382,
      NULL,
      0,
      0.154219,
      NULL,
      0,
      NULL,
      NULL,
      1.450972,
      NULL,
      NULL,
      1,
      0.400550,
      0.553876,
      0.722008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.083489,
      1.825227,
      2,
      0,
      NULL,
      0.618937,
      0,
      NULL,
      NULL,
      0.004890,
      NULL,
      NULL,
      NULL,
      1.623145,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.411231,
      0.735594,
      NULL,
      0.582803,
      0,
      1.924929,
      1.057914,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.438679,
      0.764512,
      NULL,
      1.658250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.729381,
      3.620636,
      1.255472,
      NULL,
      6,
      3,
      NULL,
      3,
      6.788893,
      NULL,
      4.277296,
      NULL,
      0.602846,
      NULL,
      3.018943,
      NULL,
      1,
      0.002689,
      3.064521,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.323365,
      0,
      1,
      NULL,
      1.111265,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.931845,
      3.111253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3.476188,
      NULL,
      0.658639,
      NULL,
      NULL,
      NULL,
      0.761280,
      1.306649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.387161,
      2.828125,
      NULL,
      2,
      1.557282,
      NULL,
      1.387972,
      NULL,
      3.976331,
      0.187552,
      1.322132,
      0.400187,
      1,
      0,
      0,
      1.217849,
      0.278094,
      1.278563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '24040',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.414696,
      '',
      '',
      '',
      NULL,
      1.526048,
      NULL,
      3.638937,
      1,
      4.135849,
      2.166448,
      2.820092,
      1.755497);
commit;
end;
/


