set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '2012403',
      NULL,
      NULL,
      NULL,
      1,
      '030304',
      1.065583,
      ' 5-29-1994',
      7,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.292382,
      NULL,
      1.875165,
      NULL,
      1,
      3.451877,
      NULL,
      2.890422,
      1.761842,
      2.258238,
      0,
      0,
      0.003883,
      1,
      2.326417,
      NULL,
      0.362851,
      0.448727,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.552750,
      NULL,
      NULL,
      0,
      0,
      1.085371,
      0.939168,
      0,
      0.754949,
      NULL,
      2,
      0.155044,
      1,
      NULL,
      1.839789,
      0,
      3,
      1.320667,
      1,
      1.186505,
      NULL,
      3,
      2.077308,
      2,
      NULL,
      0,
      1.073643,
      NULL,
      NULL,
      0.600331,
      NULL,
      NULL,
      1.297409,
      0,
      0.161996,
      NULL,
      1.710112,
      1,
      1.727529,
      1.991168,
      1.992985,
      NULL,
      1,
      1,
      1,
      NULL,
      0.498582,
      0,
      1.809621,
      0,
      0.508988,
      NULL,
      0.796374,
      6.654722,
      NULL,
      0.284749,
      6.259122,
      0,
      6.142585,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962410,
      NULL,
      1.978614,
      NULL,
      0,
      4.718121,
      6.965909,
      1,
      5.570450,
      0,
      NULL,
      6,
      NULL,
      10.071597,
      2,
      1,
      0,
      1,
      5,
      1.406529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      0,
      1.546607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.204870,
      NULL,
      NULL,
      NULL,
      NULL,
      2.052724,
      NULL,
      1,
      3,
      1,
      17.140078,
      9,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.412055,
      1.780014,
      7.870775,
      1,
      1,
      2,
      1.655834,
      NULL,
      NULL,
      NULL,
      NULL,
      3.230548,
      1.682630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.330923,
      0,
      2,
      0.988388,
      NULL,
      NULL,
      3,
      3,
      1,
      0.828833,
      1,
      1,
      1,
      0,
      0.914762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '33402',
      NULL,
      NULL,
      0.917042,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


