set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '3012240',
      13.371722,
      0,
      1,
      3,
      '303034',
      1,
      ' 2-22-1991',
      25,
      NULL,
      1,
      NULL,
      7.526375,
      1.867494,
      1.676344,
      0.750866,
      1,
      1,
      1,
      0,
      0,
      0,
      0.136181,
      0.724959,
      0.342283,
      0,
      1.029595,
      0,
      0.787747,
      1,
      0,
      2.607283,
      NULL,
      1.152379,
      NULL,
      0,
      1.348806,
      0.159710,
      NULL,
      1.552714,
      NULL,
      NULL,
      0.918392,
      NULL,
      NULL,
      1,
      1.774068,
      1,
      NULL,
      1,
      0.044206,
      1.258769,
      2,
      NULL,
      3,
      NULL,
      0,
      1,
      3.646453,
      0.149149,
      NULL,
      1.112717,
      0,
      1.852081,
      1,
      1,
      5.364800,
      3.761437,
      1,
      2,
      0.045861,
      0,
      NULL,
      NULL,
      0.379892,
      NULL,
      NULL,
      NULL,
      0.236691,
      1,
      0.432396,
      4.822886,
      1,
      0.205898,
      0.688201,
      0,
      1.377406,
      NULL,
      1.296528,
      0.501544,
      NULL,
      0.202648,
      NULL,
      0.375251,
      0,
      0,
      NULL,
      0,
      3.016227,
      NULL,
      NULL,
      1.868445,
      0.318048,
      3,
      0,
      2.374332,
      5,
      0,
      1.155047,
      NULL,
      0.773738,
      6,
      1,
      1,
      2,
      7,
      9,
      1.181204,
      6,
      1.765156,
      5,
      6,
      1,
      7.236275,
      4,
      2.684781,
      1.996162,
      0.918011,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162765,
      1,
      0,
      NULL,
      NULL,
      0.502551,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.427165,
      NULL,
      NULL,
      3,
      1,
      1.950225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.239144,
      1,
      NULL,
      NULL,
      NULL,
      0.027009,
      1,
      1.086241,
      1.984448,
      6.156369,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.233535,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.079645,
      1.513343,
      2.898725,
      1.394292,
      1.036654,
      2,
      0.823915,
      1.254246,
      2.926033,
      0.412887,
      1,
      NULL,
      NULL,
      0,
      1.071241,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528854,
      '11331',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.545846,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


