set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '1420232',
      9,
      NULL,
      0,
      3,
      '102411',
      3.914780,
      ' 4- 1-1997',
      40.504445,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.565618,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1.232377,
      2,
      0,
      1.459352,
      0,
      2.602491,
      1.848824,
      0,
      3.138119,
      0.055973,
      NULL,
      NULL,
      3,
      2,
      1.399187,
      NULL,
      1.587377,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.213711,
      0,
      1,
      0.893140,
      1.213741,
      2.495579,
      1,
      2,
      3,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      3,
      1,
      0,
      5,
      6.144699,
      NULL,
      NULL,
      1.336439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.352348,
      0,
      NULL,
      1,
      0,
      0.481204,
      0,
      1.094531,
      0,
      NULL,
      0,
      1,
      0.227052,
      NULL,
      1,
      0.177011,
      3.779418,
      0,
      5.024035,
      1.026103,
      2.609339,
      1.695827,
      3.632145,
      3,
      6,
      0,
      1,
      NULL,
      4,
      0,
      5.849624,
      NULL,
      1,
      9,
      7.611054,
      8,
      1.092939,
      5.874527,
      NULL,
      3.441549,
      5.019091,
      3,
      3.937909,
      NULL,
      1.348378,
      6.551773,
      1.998840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.532687,
      0.689300,
      1,
      0.864624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.160108,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      2.671372,
      16.354933,
      8,
      1.811455,
      1.992215,
      NULL,
      NULL,
      NULL,
      3,
      1.796208,
      1.403931,
      2.922532,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413138,
      7.289577,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624987,
      3.447028,
      2.574527,
      3,
      1,
      NULL,
      0,
      NULL,
      0.263014,
      0.062155,
      0.618630,
      1.834892,
      0.613149,
      0.819599,
      0,
      0,
      0.675542,
      0.364714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '04321',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


