set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      14,
      3,
      1,
      0,
      '224014',
      NULL,
      ' 7-21-1975',
      55,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.279104,
      0,
      0.769507,
      0.312505,
      1,
      1.288298,
      1.842947,
      0,
      0,
      1,
      0,
      0.249685,
      1,
      1,
      6,
      0,
      3.714078,
      0,
      2,
      0,
      0.880813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632587,
      NULL,
      NULL,
      NULL,
      0,
      0.207884,
      1,
      0,
      1.114849,
      NULL,
      3,
      1,
      2,
      NULL,
      0,
      0,
      0,
      3,
      1.526594,
      1.446501,
      NULL,
      1,
      1.468680,
      NULL,
      3.094236,
      0.523040,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.706410,
      NULL,
      NULL,
      0.743923,
      1,
      0.873364,
      NULL,
      NULL,
      1,
      0.482958,
      1,
      1,
      1,
      1.596531,
      0,
      0.085228,
      NULL,
      1.539211,
      0.348241,
      NULL,
      NULL,
      0,
      NULL,
      0.588381,
      2.991026,
      0,
      1.142893,
      NULL,
      0,
      0.439392,
      1.551551,
      NULL,
      1.088699,
      1,
      1.949273,
      NULL,
      NULL,
      3,
      1,
      3,
      11.623581,
      5,
      8.994193,
      NULL,
      9,
      NULL,
      9,
      7.652997,
      7,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.175786,
      0,
      0,
      0.012789,
      3.169329,
      0.355013,
      0.042532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.885987,
      NULL,
      NULL,
      NULL,
      2.020985,
      NULL,
      4,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.586912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.098414,
      NULL,
      0,
      2.772285,
      3,
      2,
      2.285909,
      0.644430,
      1,
      0,
      NULL,
      0,
      1.147625,
      NULL,
      NULL,
      NULL,
      1.785308,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '42312',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0.375883,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


