set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '4424042',
      NULL,
      5,
      NULL,
      0,
      NULL,
      3.283060,
      '11-29-1974',
      30.509782,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.995763,
      0.992198,
      0.026134,
      0,
      0.944938,
      1.828616,
      3,
      0,
      0.760500,
      NULL,
      NULL,
      0.272350,
      1,
      1,
      4.661204,
      NULL,
      3.967316,
      2,
      NULL,
      NULL,
      2,
      1,
      1,
      2,
      0.637648,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.049847,
      2.031574,
      0.538631,
      1,
      1,
      2,
      1,
      NULL,
      3.134238,
      0,
      1.158262,
      1.093711,
      3.952364,
      3,
      2.491455,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.307633,
      0.330785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.757284,
      1.908308,
      0.970702,
      NULL,
      NULL,
      1,
      0,
      0,
      1.678881,
      5,
      1,
      1,
      4,
      1.396669,
      0.256699,
      0,
      1,
      NULL,
      NULL,
      1,
      3.105551,
      1,
      1.804272,
      NULL,
      1.581805,
      2,
      NULL,
      NULL,
      1.435536,
      5,
      0.361970,
      0.011260,
      0,
      NULL,
      1.882447,
      4.800716,
      8,
      6,
      8.196120,
      5,
      6.320105,
      2,
      2.792644,
      2.094888,
      6.513542,
      7,
      6,
      0.351268,
      NULL,
      NULL,
      0.730421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.739427,
      1,
      1,
      NULL,
      2,
      0,
      1.804574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101156,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.661559,
      1.833618,
      0.111396,
      1,
      0.488156,
      NULL,
      NULL,
      NULL,
      NULL,
      4.925211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.240070,
      2,
      NULL,
      3.021241,
      1.968344,
      3.263701,
      0,
      NULL,
      0,
      3,
      2.552172,
      1.202098,
      1.838075,
      0,
      0.984542,
      NULL,
      1.988607,
      NULL,
      1.024241,
      1.721273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '20123',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.849300,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


