set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '0344243',
      NULL,
      NULL,
      3.396670,
      0,
      '100344',
      2,
      '10-26-1979',
      2.253756,
      NULL,
      1.572167,
      NULL,
      1,
      1.132071,
      NULL,
      NULL,
      1,
      3.764268,
      0,
      NULL,
      0.335716,
      0.892661,
      5,
      0.365076,
      2,
      5,
      NULL,
      1.524386,
      4.162129,
      1.844555,
      4.544193,
      NULL,
      0,
      0,
      3.035820,
      0,
      2.203149,
      2,
      0.908889,
      1.820688,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      3,
      0,
      NULL,
      1.877768,
      NULL,
      3.050723,
      NULL,
      1,
      2.826012,
      3,
      1.105478,
      1.403825,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0.219660,
      4,
      0,
      NULL,
      0,
      1,
      3.256930,
      1.209620,
      NULL,
      NULL,
      0.224085,
      NULL,
      NULL,
      0.898555,
      0,
      0.229676,
      NULL,
      0.612470,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      1.401919,
      1.789622,
      0,
      0.861053,
      1.485455,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1.283857,
      4.284669,
      1.346276,
      1,
      1.153018,
      0,
      3.140022,
      0.089743,
      NULL,
      3.328658,
      1.743535,
      NULL,
      NULL,
      5.347671,
      8.658342,
      0,
      4,
      7,
      NULL,
      0.584123,
      0,
      3,
      1.404976,
      3.929208,
      0.824008,
      0.567526,
      3.370560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1,
      0,
      0,
      0.533480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.328823,
      NULL,
      NULL,
      NULL,
      5.917340,
      NULL,
      1.392250,
      1,
      5.844672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042015,
      1,
      3,
      1,
      NULL,
      3.722834,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1.743437,
      0.874077,
      0.034097,
      0.502456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '41442',
      '',
      '',
      1.947458,
      '',
      '',
      '',
      1.413115,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


