set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '0433204',
      42,
      2,
      NULL,
      0,
      '041413',
      1,
      ' 5-16-1979',
      26,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.939169,
      3.664489,
      NULL,
      1.454706,
      0,
      0.298945,
      0,
      0.550993,
      0.441800,
      0,
      NULL,
      NULL,
      0.746855,
      0,
      NULL,
      3.638942,
      0,
      7.886712,
      NULL,
      7,
      0,
      NULL,
      3.433567,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071537,
      NULL,
      NULL,
      1.671418,
      5.551718,
      1,
      2,
      1,
      1,
      0,
      2,
      0.582253,
      NULL,
      1.413582,
      0.936628,
      3.293403,
      0,
      0,
      NULL,
      1,
      3.829774,
      0,
      NULL,
      0.689751,
      1.923076,
      5.325268,
      3,
      NULL,
      0.344326,
      0,
      NULL,
      NULL,
      0.928550,
      NULL,
      NULL,
      NULL,
      1.943748,
      1.669049,
      2,
      NULL,
      NULL,
      0.226498,
      1.985892,
      1.284590,
      1.329643,
      0,
      1,
      0.073164,
      1.603216,
      1,
      NULL,
      1.260288,
      2,
      NULL,
      NULL,
      1,
      4,
      1,
      1.965109,
      1.271253,
      1.195282,
      NULL,
      0.574188,
      0.027829,
      1.831424,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      7,
      8,
      0,
      4.160948,
      0.909281,
      2,
      8,
      7,
      3.002679,
      NULL,
      3.280467,
      NULL,
      1.797111,
      1.485761,
      2.655271,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.804417,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0,
      1.775833,
      NULL,
      NULL,
      NULL,
      3,
      1.432779,
      NULL,
      NULL,
      1.280925,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5.106064,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.447450,
      3,
      NULL,
      2,
      NULL,
      1.554792,
      0,
      0,
      0.266710,
      1.535632,
      1,
      NULL,
      1.017553,
      1,
      0.601570,
      NULL,
      0,
      0.001607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.051695,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


