set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '2031241',
      17,
      3,
      3,
      NULL,
      '424011',
      NULL,
      ' 7- 6-1997',
      20.443942,
      NULL,
      0.087620,
      NULL,
      1.823127,
      0,
      1.362906,
      0.829528,
      0,
      0,
      0.620682,
      1.334497,
      0.222541,
      0.743743,
      0.221699,
      NULL,
      5,
      1.420602,
      0,
      0.486245,
      7.009269,
      1,
      1,
      1,
      1,
      1.790919,
      2,
      NULL,
      0.254277,
      5,
      2,
      0,
      NULL,
      NULL,
      0.115088,
      NULL,
      NULL,
      5.604307,
      0,
      4,
      3,
      NULL,
      NULL,
      2.279922,
      2,
      0.985638,
      1.036502,
      3.910615,
      0.114476,
      0,
      2.135011,
      NULL,
      1.140643,
      3,
      1.551966,
      1,
      3.154170,
      3,
      1,
      0,
      0,
      2,
      3.648881,
      1,
      NULL,
      NULL,
      1.538119,
      NULL,
      NULL,
      NULL,
      1.551986,
      1,
      NULL,
      0,
      1.677477,
      1.914735,
      NULL,
      1.173482,
      0,
      0,
      1,
      0.160135,
      2.276602,
      0,
      0.174545,
      1,
      1,
      NULL,
      NULL,
      1.901971,
      NULL,
      1.796334,
      NULL,
      NULL,
      0,
      5.444750,
      1.704008,
      1,
      1.185294,
      4,
      0,
      NULL,
      1.650309,
      3.062347,
      1.418012,
      5,
      3.009587,
      5.071620,
      5.597999,
      5.975058,
      6.908734,
      0,
      NULL,
      9.329495,
      1,
      0.614778,
      1.036745,
      2.133080,
      0.963564,
      0.261528,
      3.002074,
      0.273142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558925,
      NULL,
      NULL,
      1,
      1.124081,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.154586,
      2.956740,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.146667,
      0,
      0.115248,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.853188,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.147259,
      0,
      1,
      3,
      0,
      0.523630,
      1,
      2,
      1,
      NULL,
      0,
      0,
      0.026738,
      NULL,
      0.165798,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '41040',
      '',
      '',
      1.816274,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


