set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '0440324',
      21.420129,
      5,
      3,
      2,
      '010403',
      3,
      NULL,
      29.362176,
      NULL,
      1.814434,
      NULL,
      6,
      3,
      1.057193,
      1,
      1.657582,
      1,
      1,
      1,
      0.991939,
      NULL,
      2,
      1,
      0,
      2,
      0.188972,
      1,
      3.281323,
      1,
      5.611190,
      0.028699,
      1,
      4,
      0,
      0,
      0,
      0.921095,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.081864,
      1.354553,
      1.340083,
      0,
      0.358793,
      0.387126,
      2.428886,
      NULL,
      3,
      1.439813,
      2,
      NULL,
      2,
      0,
      NULL,
      0.502103,
      2,
      2,
      3.149433,
      2.397477,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.879660,
      NULL,
      NULL,
      1.636483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582322,
      3,
      NULL,
      1,
      1,
      1,
      0,
      1.055099,
      1.750988,
      0.735641,
      NULL,
      0.140758,
      1.655567,
      1,
      0.677562,
      1.018661,
      NULL,
      0,
      1,
      0,
      NULL,
      1.953607,
      0,
      1,
      1,
      0.204610,
      NULL,
      3,
      NULL,
      1,
      0.052130,
      5,
      0.150278,
      7,
      5,
      4,
      1.285990,
      NULL,
      2.181867,
      3.201315,
      7.631224,
      NULL,
      9.630535,
      NULL,
      8,
      0,
      0.926436,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      0.109997,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.573947,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402154,
      NULL,
      NULL,
      2.360075,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.209070,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.458479,
      1.478347,
      3,
      1,
      1,
      2.800553,
      0,
      1,
      1.611141,
      1,
      NULL,
      0.760707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1.006283,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


