set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '1232123',
      5.924151,
      3,
      1,
      NULL,
      '331144',
      1,
      NULL,
      38.867357,
      NULL,
      1,
      NULL,
      5,
      1,
      0.452882,
      1.675667,
      0.149330,
      3,
      0.430361,
      NULL,
      2.032582,
      0.089516,
      4.207725,
      0.694529,
      0,
      1.611811,
      NULL,
      1,
      4,
      4.983184,
      NULL,
      0.591272,
      6,
      1.236139,
      4,
      3,
      NULL,
      1.295678,
      NULL,
      0.586996,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      4,
      2.301485,
      NULL,
      0.443260,
      0,
      3,
      3.618761,
      0.166662,
      1.802375,
      1,
      1.738433,
      1.918393,
      1,
      1,
      1,
      3.772988,
      1,
      2,
      0.480823,
      NULL,
      5,
      NULL,
      0,
      NULL,
      1,
      1.426345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.489920,
      NULL,
      3.498900,
      1,
      3,
      1.784129,
      NULL,
      0.682853,
      1.857863,
      1.007026,
      2,
      0,
      1,
      1.151607,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.511829,
      0.562877,
      1,
      NULL,
      1,
      1.135824,
      NULL,
      1.304759,
      NULL,
      1.516967,
      0.548666,
      1,
      NULL,
      7,
      NULL,
      8.459555,
      7,
      0.805217,
      NULL,
      0,
      0.016255,
      NULL,
      1.770126,
      3,
      1.979457,
      NULL,
      1,
      2.741590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422770,
      NULL,
      NULL,
      1,
      0,
      1,
      0.345038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.097226,
      2.199770,
      1.288492,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.419589,
      NULL,
      NULL,
      1,
      1.465920,
      NULL,
      NULL,
      NULL,
      1,
      10,
      0.742544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.687616,
      3,
      0,
      3.455656,
      2.322871,
      3.449459,
      1,
      NULL,
      0.402931,
      1,
      0.385491,
      NULL,
      1,
      0.804324,
      0.473438,
      1.501834,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '22320',
      '',
      '',
      1.769313,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


