set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '0033241',
      40,
      0,
      2,
      1,
      '224310',
      1.078063,
      NULL,
      NULL,
      NULL,
      1.750861,
      NULL,
      3.283636,
      1,
      NULL,
      0.605557,
      0,
      1,
      0,
      0.833392,
      NULL,
      1,
      2.627316,
      1.406177,
      NULL,
      2,
      1,
      1,
      1.347169,
      5,
      2.571915,
      3,
      NULL,
      2,
      4.330349,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.282569,
      NULL,
      7,
      NULL,
      1.681232,
      0,
      3,
      NULL,
      0.642165,
      0,
      0,
      NULL,
      1,
      3,
      0,
      1,
      0.812318,
      1,
      NULL,
      0.396465,
      0,
      2,
      1.100159,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.324239,
      1,
      0.199799,
      0,
      0,
      1.184274,
      3,
      1,
      1.651890,
      1,
      1.116869,
      1.582952,
      NULL,
      1,
      1.844335,
      1.098647,
      1.315893,
      0.687875,
      1.393271,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      2,
      1,
      1.464547,
      1,
      1.372270,
      1,
      NULL,
      0,
      1.143228,
      3.463579,
      5,
      6,
      6.812938,
      3,
      2.252116,
      NULL,
      0,
      7.620221,
      3,
      NULL,
      5.018174,
      2,
      NULL,
      1,
      1,
      4.597486,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270993,
      NULL,
      1,
      1,
      2,
      0.545118,
      0.774748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300426,
      0.414033,
      1,
      1.871554,
      3,
      9.979447,
      3,
      1.183411,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387928,
      NULL,
      5.265372,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.111020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212121,
      NULL,
      NULL,
      3,
      NULL,
      1.022435,
      1,
      2.925700,
      2.932583,
      1,
      1,
      0.900231,
      1.410507,
      1.779403,
      NULL,
      0,
      0,
      0.806189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119431,
      '21134',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.915525,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


