set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '1131344',
      119.836611,
      NULL,
      3,
      NULL,
      '240040',
      2.684026,
      ' 6-16-1980',
      55.773833,
      NULL,
      NULL,
      NULL,
      1,
      1.421826,
      NULL,
      0.259348,
      1.070033,
      1.477865,
      1,
      1.344669,
      0,
      0.534006,
      4.772547,
      NULL,
      1.656236,
      0,
      3.178439,
      0,
      5.033442,
      3.024627,
      2,
      NULL,
      NULL,
      7.329288,
      NULL,
      1,
      1,
      NULL,
      0.208541,
      0.926698,
      NULL,
      NULL,
      1.455729,
      NULL,
      NULL,
      1,
      2.799284,
      1.574790,
      NULL,
      1.894328,
      3.771846,
      3,
      0.971274,
      0.799784,
      NULL,
      3,
      3.429814,
      2.743626,
      2.846943,
      NULL,
      NULL,
      0.376277,
      0,
      0,
      1,
      3.467844,
      0.394169,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336055,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.708472,
      1,
      2.655085,
      4.813495,
      NULL,
      1,
      0,
      4.675325,
      0.297127,
      1.684438,
      5.980659,
      0,
      0.222020,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5.496133,
      0,
      0.495453,
      1.091471,
      0,
      7.819754,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079917,
      2.548823,
      0,
      0.282263,
      5.823769,
      6,
      4.718716,
      7.997714,
      0,
      5,
      4,
      NULL,
      7,
      NULL,
      11,
      7.826654,
      1,
      0.210834,
      0,
      3.146536,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.023737,
      NULL,
      NULL,
      0.131609,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.617497,
      1.402286,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149134,
      4.998759,
      3.600710,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.344087,
      2.075937,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.875181,
      1.351037,
      1,
      NULL,
      2,
      0,
      1.853337,
      NULL,
      1,
      0,
      1.597719,
      1.452547,
      1.748138,
      0.330500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.434868,
      '04400',
      '',
      '',
      0.507540,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


