set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '1114041',
      47,
      1,
      3.455714,
      NULL,
      '103320',
      2.767645,
      NULL,
      35,
      NULL,
      1.268776,
      NULL,
      NULL,
      1.013050,
      3.026505,
      1.261156,
      1.460923,
      NULL,
      1,
      NULL,
      1,
      0,
      0.692118,
      0.059355,
      0,
      NULL,
      1,
      0.686663,
      7,
      3.204192,
      6.994769,
      3,
      3.138253,
      0,
      7,
      1,
      2.340877,
      2.298854,
      2,
      1.636688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      2,
      NULL,
      1,
      1.213006,
      NULL,
      0.167462,
      NULL,
      1,
      0.820053,
      3,
      1.135905,
      NULL,
      2,
      0.308882,
      2.585493,
      3,
      1,
      0.230265,
      1.169216,
      2.769290,
      1.251268,
      6.009299,
      1,
      1,
      0.773308,
      0,
      NULL,
      NULL,
      1.084841,
      NULL,
      NULL,
      0,
      1,
      0,
      0.619130,
      1,
      NULL,
      3.804643,
      0.013310,
      1,
      1,
      4.008016,
      0.324624,
      0,
      2,
      1,
      1,
      0,
      1.004096,
      0.898253,
      NULL,
      0.905411,
      7,
      1.732645,
      1,
      1,
      NULL,
      6.549701,
      NULL,
      NULL,
      3.456654,
      1,
      1.010654,
      1,
      0.776778,
      NULL,
      NULL,
      2.026673,
      NULL,
      4.940445,
      NULL,
      3.702652,
      3.506615,
      NULL,
      1.403957,
      9.357688,
      0,
      1.566834,
      5,
      3.117306,
      0.138669,
      1,
      3.849382,
      0.722858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502580,
      2,
      0,
      0,
      1.519820,
      NULL,
      0.130303,
      0.822897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349153,
      1,
      0.049933,
      NULL,
      NULL,
      5.975761,
      3.731187,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.020471,
      0,
      3,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.827380,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.119090,
      1.873091,
      1.877069,
      0,
      0.085537,
      1,
      0.145884,
      1.828679,
      3.003319,
      0.670747,
      1.712122,
      0,
      1.360285,
      1.455563,
      0.348210,
      NULL,
      NULL,
      1.159659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '40013',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1.560280,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


