set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '0440422',
      90.804897,
      3,
      2,
      1,
      '301042',
      0,
      '11-24-1999',
      53.186012,
      NULL,
      0.086933,
      NULL,
      5,
      0,
      3,
      0.869748,
      1,
      3.762480,
      0,
      0,
      3.329793,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      1.276881,
      6,
      1.489490,
      NULL,
      2,
      5.108549,
      NULL,
      0,
      1,
      0,
      NULL,
      1.866968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633118,
      1.143062,
      1.463090,
      2.173500,
      0,
      0,
      1,
      3.894025,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.440674,
      1,
      2,
      1,
      0.837575,
      2,
      NULL,
      NULL,
      0.753502,
      0.027930,
      1,
      1,
      1,
      0.988951,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.422875,
      1.975643,
      1,
      NULL,
      1,
      2.317035,
      NULL,
      0,
      NULL,
      2.508360,
      1.365332,
      NULL,
      5.149586,
      0.411036,
      NULL,
      NULL,
      1.797000,
      0,
      NULL,
      1,
      2,
      0.404661,
      1.225502,
      3.574680,
      1,
      5.922923,
      1.111612,
      NULL,
      1.597120,
      1.483950,
      NULL,
      0.984835,
      0.501468,
      1.192215,
      NULL,
      1.255200,
      6.426932,
      6.463578,
      9.964694,
      6,
      9,
      0,
      1,
      7.339525,
      2,
      NULL,
      NULL,
      2,
      0.810451,
      1.986772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      1.378097,
      1.490337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642523,
      NULL,
      NULL,
      NULL,
      NULL,
      4.820854,
      1.329484,
      NULL,
      1.498789,
      2,
      4.924987,
      NULL,
      3.502853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.789006,
      0,
      0.482268,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048043,
      3,
      3.306065,
      1,
      NULL,
      2,
      1.058248,
      2.837025,
      NULL,
      NULL,
      1.939793,
      0,
      NULL,
      0.587847,
      NULL,
      NULL,
      1.779688,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '44200',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


