set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      129,
      2,
      NULL,
      1,
      '332111',
      1.540012,
      NULL,
      25.620908,
      NULL,
      0.367640,
      NULL,
      6,
      0.496213,
      3.125865,
      0.533453,
      NULL,
      2.062465,
      1,
      NULL,
      NULL,
      1,
      2,
      0.905146,
      0,
      1,
      NULL,
      0.797647,
      3.922053,
      NULL,
      NULL,
      1.230015,
      1,
      1.684909,
      NULL,
      0,
      NULL,
      NULL,
      1.152129,
      1.447104,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.378209,
      2.187021,
      NULL,
      0.576287,
      0.228698,
      2.853227,
      3,
      3,
      1,
      3,
      3,
      3.701033,
      NULL,
      0.058644,
      0.173583,
      2.678717,
      0,
      0.218094,
      1.650941,
      0.919296,
      NULL,
      1.406918,
      2,
      NULL,
      0,
      0,
      0.048141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.803792,
      1.718813,
      0,
      1.825338,
      NULL,
      0,
      4,
      NULL,
      1.725151,
      1.918710,
      0.793332,
      0.008214,
      0,
      5.935651,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      3.276704,
      1.876042,
      0.330803,
      NULL,
      NULL,
      2.040085,
      1,
      1,
      0.326810,
      0.825114,
      0,
      1.469659,
      NULL,
      2.369453,
      1.716576,
      3,
      4.741581,
      7,
      0,
      2,
      6,
      NULL,
      3.256298,
      7.926796,
      0,
      NULL,
      NULL,
      0.392013,
      NULL,
      0.166826,
      3,
      0.700963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.359864,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.522790,
      1.234887,
      1.720396,
      NULL,
      NULL,
      NULL,
      2.507934,
      1,
      2.270937,
      4.001959,
      1.744259,
      NULL,
      1.519766,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.078072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.900475,
      2,
      3,
      NULL,
      3,
      2,
      1.787044,
      1.751606,
      0.462204,
      NULL,
      0.828395,
      0,
      1,
      1.372825,
      0,
      0.019883,
      1,
      0.715618,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.989161,
      '00430',
      '',
      '',
      0,
      '',
      '',
      '',
      0.359203,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


