set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '0014443',
      NULL,
      4,
      3,
      3,
      NULL,
      1.564555,
      NULL,
      57.293444,
      NULL,
      0.615762,
      NULL,
      6.791391,
      NULL,
      NULL,
      1,
      0,
      2.049845,
      1.656872,
      1.387552,
      3,
      1.371708,
      3.961747,
      NULL,
      NULL,
      3,
      2,
      0.242507,
      4,
      NULL,
      5.796441,
      1,
      2.894025,
      2.919962,
      1,
      0,
      2,
      1.776083,
      2.234071,
      1.849496,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0.840052,
      NULL,
      3.040510,
      0,
      1,
      NULL,
      1.172385,
      1,
      0.469165,
      NULL,
      NULL,
      1.889101,
      1,
      NULL,
      NULL,
      1,
      1,
      1.569865,
      0,
      0,
      NULL,
      NULL,
      0,
      2,
      1.389199,
      1,
      NULL,
      NULL,
      1.675609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646742,
      0.266724,
      1,
      2,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      1,
      0,
      1.278335,
      0,
      0,
      1,
      NULL,
      0.908221,
      3.688644,
      1.836968,
      1.587042,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.533280,
      0.572190,
      NULL,
      2.205296,
      3,
      1.953543,
      0,
      4,
      0,
      2,
      1.340340,
      2.007673,
      6,
      NULL,
      8.086558,
      NULL,
      0.940475,
      0.958202,
      NULL,
      2.690249,
      0,
      0,
      2.654784,
      1.932360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700853,
      0,
      1,
      2,
      1.615897,
      0,
      1.327992,
      0.601118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      NULL,
      4.973757,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.349218,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794430,
      3,
      2,
      1.860343,
      3.847015,
      0.108874,
      1.966885,
      0.265272,
      0.739918,
      0.520610,
      3,
      NULL,
      1.083404,
      NULL,
      1.296885,
      NULL,
      1.643185,
      NULL,
      NULL,
      1.101400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.116338,
      '12143',
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      1.019073,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


