set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30',
      16.121299,
      12.014209,
      '3142400',
      76,
      NULL,
      NULL,
      0,
      '413012',
      NULL,
      '10-25-1977',
      NULL,
      54,
      1,
      NULL,
      NULL,
      0,
      3.710903,
      1.041957,
      0,
      3.523261,
      1.755880,
      0.727193,
      2.308912,
      1,
      4.307527,
      0.599689,
      1,
      2.597157,
      1,
      0,
      NULL,
      1.656590,
      1,
      1.918974,
      3.140312,
      4,
      5,
      0,
      2.477491,
      1.557814,
      NULL,
      1,
      NULL,
      NULL,
      1.173927,
      NULL,
      NULL,
      5.128647,
      NULL,
      1.030599,
      3,
      3,
      2.379479,
      1,
      0.043446,
      0.329644,
      0,
      0,
      2.532121,
      1.447914,
      NULL,
      2.425181,
      NULL,
      3.534215,
      1,
      0.600916,
      3.432560,
      NULL,
      2,
      NULL,
      1,
      1,
      1.494831,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.980378,
      0,
      0,
      1.682147,
      NULL,
      1.508521,
      1.573341,
      0,
      NULL,
      1.345619,
      0,
      1.829571,
      2.272853,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.257009,
      NULL,
      1,
      2.369549,
      0,
      NULL,
      NULL,
      1.858314,
      0.992574,
      3.903366,
      3,
      0,
      3.236373,
      0.061332,
      0,
      1.946678,
      5,
      1.856248,
      NULL,
      7,
      1.263113,
      1.850042,
      2,
      6.890102,
      1,
      NULL,
      3,
      2,
      3.669909,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1.227849,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.955910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898267,
      1.611456,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209340,
      3.941560,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125453,
      1.802120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3.687817,
      0.272329,
      1,
      NULL,
      1.287442,
      NULL,
      NULL,
      1,
      NULL,
      1.190320,
      0.310356,
      0.064529,
      1.009493,
      0.422733,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '42142',
      NULL,
      '',
      1.241079,
      '',
      '',
      '',
      0.200528,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


