set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      '03',
      15.440679,
      NULL,
      '3021124',
      64.273590,
      4,
      3.164881,
      0,
      '133213',
      2.657021,
      NULL,
      6.860949,
      23.996704,
      NULL,
      NULL,
      6,
      NULL,
      0.468923,
      NULL,
      0,
      3.616845,
      NULL,
      1.935715,
      3.424306,
      1.143177,
      1,
      1.861579,
      1.960130,
      5.614504,
      0.753520,
      1,
      2,
      1.409768,
      NULL,
      1,
      4.035015,
      3,
      5.256644,
      1,
      NULL,
      NULL,
      2.536510,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      0.655361,
      3,
      NULL,
      NULL,
      1.677161,
      1,
      1.477016,
      1.117745,
      NULL,
      0,
      0,
      0.033395,
      2.744015,
      NULL,
      1,
      1,
      0,
      0.242269,
      1.264524,
      0.672029,
      NULL,
      1,
      1,
      0.146668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.533201,
      0.108013,
      0,
      0.940876,
      0.137111,
      1,
      0,
      1,
      1,
      0.439210,
      1,
      1.401880,
      0,
      0.430716,
      0.588003,
      1.538583,
      NULL,
      NULL,
      3.166706,
      0.648345,
      NULL,
      NULL,
      0,
      2.774742,
      NULL,
      5.761200,
      NULL,
      2.457318,
      NULL,
      0.003128,
      NULL,
      4.851376,
      0.388856,
      6,
      7,
      1,
      3,
      0.286979,
      6,
      NULL,
      NULL,
      2.880564,
      3,
      4,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.167356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      1.804062,
      0.227289,
      NULL,
      1.063443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.159022,
      3.864132,
      1,
      NULL,
      NULL,
      NULL,
      1.477203,
      0,
      NULL,
      NULL,
      1.564522,
      0,
      1.277009,
      NULL,
      NULL,
      NULL,
      0,
      2.523663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967408,
      NULL,
      2,
      3.303834,
      1,
      2.005401,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.090182,
      0.910238,
      1.964974,
      0.083460,
      1.285656,
      0.063852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '43441',
      '',
      '',
      0.037944,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


