set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22',
      NULL,
      NULL,
      '1331112',
      91,
      NULL,
      3,
      2,
      '342124',
      NULL,
      ' 0-13-1987',
      12.341300,
      30.632912,
      0,
      NULL,
      4.038054,
      0.412305,
      1,
      0.257947,
      1.910678,
      NULL,
      1,
      0.894124,
      NULL,
      0,
      1,
      NULL,
      1.145072,
      NULL,
      0.068271,
      NULL,
      NULL,
      NULL,
      1,
      5.506239,
      3,
      3,
      4.167153,
      1,
      5.462581,
      NULL,
      2.122982,
      1,
      NULL,
      NULL,
      1.382204,
      NULL,
      NULL,
      2.259145,
      1,
      NULL,
      3.022682,
      2.130183,
      NULL,
      NULL,
      2.856462,
      1.629394,
      NULL,
      0.064075,
      1.109049,
      0,
      NULL,
      NULL,
      2,
      0.722294,
      0.082705,
      1,
      NULL,
      NULL,
      1.249754,
      0,
      NULL,
      NULL,
      0.596831,
      1.774246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.259562,
      1,
      NULL,
      1,
      0.001654,
      0,
      1,
      1.959910,
      1.156227,
      0,
      5.036793,
      1.388709,
      1,
      0,
      NULL,
      0.371644,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.500024,
      0,
      6.753992,
      0,
      3,
      0,
      NULL,
      1.106949,
      1,
      1.102127,
      NULL,
      1.003860,
      NULL,
      3,
      8.776889,
      0,
      4,
      8,
      5,
      11.718586,
      4,
      3,
      6.943529,
      7,
      2.096996,
      NULL,
      1.031623,
      4,
      1.924607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660543,
      1,
      2,
      0,
      1.998410,
      1.463790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.627141,
      0,
      2,
      2.356329,
      2.638659,
      3.989471,
      NULL,
      1,
      0.859070,
      NULL,
      0.095813,
      1,
      1,
      1.178615,
      NULL,
      NULL,
      0,
      0,
      1.765734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.842015,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.793026,
      '',
      '',
      NULL,
      5.777179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


