set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2,
      NULL,
      '2013211',
      17,
      NULL,
      3,
      3,
      '403304',
      5.388971,
      '10-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068794,
      1.923720,
      NULL,
      NULL,
      1,
      0,
      0.032756,
      1,
      0.971774,
      NULL,
      1.460046,
      3,
      3.538631,
      NULL,
      0.837298,
      3.524307,
      3,
      3,
      NULL,
      2.237433,
      5.771173,
      6.272989,
      1,
      3,
      5.238726,
      3,
      0,
      NULL,
      NULL,
      1.102542,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      2,
      1,
      3.097470,
      0,
      1,
      0.529783,
      2.549351,
      0.104037,
      1.039671,
      0,
      NULL,
      NULL,
      1,
      0.530407,
      NULL,
      1,
      0.569096,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400222,
      1,
      0,
      1.338365,
      1,
      NULL,
      NULL,
      1,
      0.570094,
      1,
      5,
      0,
      1,
      2,
      0,
      0,
      1,
      0,
      0.042085,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804163,
      5,
      1,
      7,
      1,
      6.271743,
      1.059924,
      3,
      0,
      1.043133,
      1.535022,
      0,
      1.437979,
      4.994439,
      4.111897,
      8,
      NULL,
      0,
      10,
      7.977506,
      5.924114,
      NULL,
      2,
      NULL,
      6,
      2,
      0.507814,
      1.298959,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437715,
      0.658874,
      1,
      1,
      0,
      1.031041,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.241324,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      5,
      0.908327,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.780027,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.984076,
      0,
      NULL,
      2,
      NULL,
      3.559992,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088435,
      1.287843,
      1.049892,
      1.705668,
      0,
      1,
      0,
      1.335361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11244',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.767024,
      '',
      '',
      '',
      0.918797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


