set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '314',
      '43',
      40.599597,
      NULL,
      '1023213',
      NULL,
      3,
      0,
      NULL,
      '042041',
      2,
      ' 1-12-2000',
      40.537640,
      33,
      0,
      NULL,
      1,
      NULL,
      1.689672,
      1,
      1,
      1.676571,
      0.182475,
      0.086106,
      0,
      0.913677,
      1,
      1.674271,
      0.891003,
      1,
      3,
      0,
      2.906664,
      0.897900,
      NULL,
      5,
      3.082203,
      2.392145,
      2,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.083482,
      NULL,
      NULL,
      5.215879,
      2.063925,
      NULL,
      0.649121,
      1.414119,
      3,
      3,
      1.402882,
      0,
      NULL,
      0,
      0.725427,
      1,
      NULL,
      1.160504,
      3.060595,
      0.959269,
      1,
      1,
      0,
      0,
      1,
      5.544249,
      0,
      2,
      0.731029,
      0.857429,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.420664,
      0,
      0.151551,
      0.764476,
      0.103735,
      1,
      1.736187,
      3.008102,
      0.145112,
      1.795375,
      3.354434,
      NULL,
      1.804124,
      0,
      0.596585,
      1.625422,
      NULL,
      1.537127,
      4.688956,
      NULL,
      1,
      3.679347,
      0.282026,
      4.152434,
      NULL,
      2.704274,
      0.339291,
      4.316873,
      2.862824,
      1,
      0.747814,
      6.692435,
      NULL,
      1.035338,
      NULL,
      5,
      1,
      1,
      11,
      NULL,
      10.585147,
      8,
      1.306049,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738558,
      5.413334,
      2,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.345103,
      0.794987,
      0.895243,
      NULL,
      NULL,
      NULL,
      2,
      1.970890,
      8,
      2,
      0.575531,
      2,
      0.714392,
      NULL,
      NULL,
      NULL,
      1,
      7.936839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447621,
      NULL,
      NULL,
      1.149353,
      1,
      3.549576,
      2.706485,
      0,
      0,
      2.369121,
      0,
      NULL,
      0.758092,
      NULL,
      1,
      1.518251,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.131356,
      '31201',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      0.793359,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


