set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      NULL,
      30,
      20.183191,
      '1422200',
      206.752769,
      3,
      NULL,
      3,
      '443243',
      3,
      ' 3- 4-2002',
      22.061965,
      NULL,
      0.585226,
      NULL,
      NULL,
      0,
      1.555718,
      0,
      NULL,
      0.996098,
      NULL,
      1.868882,
      NULL,
      1.516089,
      5.392896,
      0.744090,
      0.824943,
      1,
      NULL,
      1.208421,
      7.720195,
      4,
      NULL,
      4.443006,
      1,
      5,
      1,
      1,
      NULL,
      0,
      2.257285,
      0.658533,
      NULL,
      NULL,
      1.512619,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.627626,
      1,
      2.119067,
      1.593063,
      1.663431,
      NULL,
      3.739163,
      1,
      NULL,
      NULL,
      2,
      1.279209,
      NULL,
      0,
      0,
      0,
      0,
      0.305461,
      1.734683,
      3.337987,
      1,
      0,
      0,
      1.844568,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.180688,
      1,
      1.999933,
      1,
      0,
      NULL,
      NULL,
      1.470175,
      1.184242,
      0,
      2,
      0,
      1,
      1,
      0,
      0,
      0,
      0.475865,
      0,
      NULL,
      0.565742,
      NULL,
      0,
      0,
      NULL,
      0.440657,
      6,
      1.532750,
      1.548028,
      2.896988,
      4,
      4,
      0.091151,
      0.789429,
      0.666246,
      1,
      NULL,
      5.470966,
      6.358147,
      5,
      9,
      10,
      4,
      7,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.832122,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.343573,
      4.748468,
      3,
      0.712165,
      2,
      1.298323,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.791626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.783523,
      3,
      NULL,
      2.972103,
      1.295662,
      1.394273,
      NULL,
      0,
      3,
      NULL,
      1.234113,
      1,
      NULL,
      NULL,
      NULL,
      1.308959,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.989647,
      NULL,
      '',
      '',
      1.401083,
      '',
      NULL,
      '',
      0.936219,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


