set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '32',
      NULL,
      11,
      '4234444',
      132,
      4,
      3,
      1,
      NULL,
      2,
      ' 7-13-2002',
      1.125065,
      4.168324,
      1,
      NULL,
      1.653399,
      1,
      3.302708,
      1,
      1.662190,
      0.473891,
      0,
      1,
      1,
      0.967893,
      1,
      1,
      1.007931,
      3,
      1.747491,
      NULL,
      1,
      NULL,
      2.838658,
      2.424911,
      3,
      5.596064,
      NULL,
      0,
      3.306333,
      1.400992,
      3.812503,
      0.045337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.810975,
      NULL,
      0,
      3,
      1,
      3,
      2.016405,
      NULL,
      0,
      NULL,
      1,
      0.672132,
      NULL,
      1,
      NULL,
      2,
      0.950120,
      NULL,
      0,
      0,
      0.946060,
      2,
      NULL,
      1,
      0,
      1.301850,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0.342284,
      0.663003,
      0,
      1,
      1.603900,
      1,
      0.997833,
      0.706556,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.146488,
      NULL,
      NULL,
      1.791971,
      4.861592,
      0.723056,
      NULL,
      3.566010,
      NULL,
      NULL,
      NULL,
      NULL,
      5.473459,
      NULL,
      2.670974,
      NULL,
      NULL,
      9.648287,
      5.415081,
      0.094283,
      8,
      0,
      2,
      NULL,
      4,
      NULL,
      8.444228,
      2.460900,
      3,
      0.639028,
      NULL,
      NULL,
      0.027673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287539,
      4,
      2,
      0,
      0.664141,
      0.132234,
      0,
      0.605307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.441442,
      NULL,
      NULL,
      0,
      0.766025,
      NULL,
      NULL,
      NULL,
      1.641093,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.860579,
      0.978606,
      1.234599,
      NULL,
      2,
      0,
      3.758525,
      0,
      2.565147,
      3.538622,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1.104039,
      1.749373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.694913,
      NULL,
      NULL,
      '',
      1.773148,
      '',
      '',
      NULL,
      1.743272,
      '',
      '',
      NULL,
      NULL,
      1.391656,
      1.641078,
      NULL,
      0.235196,
      2,
      0.311996,
      NULL,
      NULL);
commit;
end;
/


