set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43242332',
      48.766195,
      11,
      '1404243',
      185.260685,
      2,
      1.414252,
      NULL,
      '102124',
      0.223945,
      ' 3-20-1979',
      NULL,
      NULL,
      0,
      NULL,
      0.248663,
      1.133266,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.434550,
      0.182323,
      1.847649,
      2.617337,
      3.466738,
      NULL,
      NULL,
      NULL,
      0,
      1.206216,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      0.965881,
      NULL,
      NULL,
      NULL,
      1.865676,
      NULL,
      NULL,
      4.374663,
      0.379008,
      NULL,
      2.629068,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      1.884863,
      NULL,
      0.437569,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.001019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.781249,
      NULL,
      NULL,
      0.682788,
      0.296233,
      1.695603,
      0,
      0.191609,
      1,
      NULL,
      NULL,
      0,
      0,
      1.598767,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4.560457,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.772318,
      NULL,
      5,
      0.110280,
      4,
      NULL,
      0,
      8,
      0.350584,
      9.351453,
      3,
      7.461230,
      8,
      5,
      NULL,
      5.818836,
      NULL,
      1,
      NULL,
      5.573465,
      1.779913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      0,
      0.602000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.154231,
      NULL,
      NULL,
      NULL,
      NULL,
      2.276432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.946957,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.785192,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      2,
      1,
      NULL,
      NULL,
      3,
      2.419346,
      NULL,
      1.903864,
      1,
      1.178617,
      1.227036,
      NULL,
      0.082849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '',
      '',
      1.122948,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.705510,
      5,
      0,
      1.673100,
      2.817530,
      NULL,
      1,
      NULL,
      2.462294);
commit;
end;
/


