set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      '44221423',
      7.660475,
      45,
      '3310012',
      NULL,
      4,
      0.307962,
      1,
      '210203',
      NULL,
      ' 8- 7-1981',
      NULL,
      65.729401,
      NULL,
      NULL,
      5,
      0,
      0.341162,
      1.115257,
      2,
      0,
      1.212949,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1.484168,
      1,
      0.400770,
      4.002442,
      NULL,
      0.523653,
      1.970311,
      5.647481,
      4,
      1.932093,
      1,
      4,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.431154,
      3.466391,
      1,
      1,
      3.239763,
      0,
      NULL,
      1.812481,
      0.901222,
      3,
      0.025922,
      0,
      3.820100,
      1,
      1,
      0.333775,
      0,
      0,
      0,
      0.017968,
      2,
      2,
      NULL,
      NULL,
      0.443718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406896,
      0,
      1,
      1,
      1,
      0.977647,
      1,
      0.733692,
      0.094770,
      3.697096,
      0,
      0.790927,
      2.081861,
      NULL,
      NULL,
      NULL,
      1.164179,
      1,
      NULL,
      1,
      7,
      1.260005,
      0.839421,
      NULL,
      1,
      6,
      0.967607,
      NULL,
      NULL,
      1,
      1,
      3,
      0.822982,
      NULL,
      1.624122,
      1.835278,
      4.550492,
      NULL,
      3,
      2,
      NULL,
      NULL,
      5.863703,
      0.303936,
      1.365861,
      8.588760,
      0.785520,
      1,
      1.140125,
      1.162994,
      3.131313,
      0.237618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0.643081,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.719355,
      3,
      0.480743,
      1.564393,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      6,
      1.066069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      1.415689,
      NULL,
      0.663970,
      1,
      3.694757,
      1.252797,
      1,
      0.805968,
      0.910778,
      1,
      1,
      1.807722,
      1.446842,
      1.933429,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.749754,
      '',
      '',
      '',
      4.907784,
      2.438270,
      2,
      2,
      1.540871,
      3,
      0.150086,
      0,
      0.532748);
commit;
end;
/


