set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '34302342',
      NULL,
      21.390064,
      '4202332',
      60.872733,
      4,
      3.735992,
      0,
      '200434',
      NULL,
      ' 4-10-1981',
      5,
      16.136798,
      1.466034,
      NULL,
      1.216037,
      NULL,
      0.740312,
      1.698513,
      1,
      0,
      NULL,
      0.255868,
      3,
      0,
      3,
      0.554531,
      1,
      1.186549,
      1,
      1.512221,
      NULL,
      0,
      NULL,
      1.915482,
      3,
      4.083125,
      2,
      1,
      4.186357,
      2.917561,
      NULL,
      0,
      NULL,
      NULL,
      0.970323,
      NULL,
      NULL,
      NULL,
      2.044558,
      4.681072,
      1,
      3,
      0.272984,
      2,
      0,
      1,
      1,
      2,
      0.859363,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.951339,
      1.063995,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      1.423698,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190602,
      1,
      1.931238,
      0.243692,
      1.496820,
      NULL,
      0,
      1.414014,
      1,
      0.349524,
      NULL,
      3,
      1.146519,
      NULL,
      1.885441,
      0.053095,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0.011103,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.204454,
      1.655339,
      NULL,
      NULL,
      1,
      4.781065,
      NULL,
      7.151751,
      1.866981,
      10.509929,
      2,
      10.021604,
      7.218817,
      NULL,
      0,
      1.609378,
      3,
      1,
      NULL,
      4,
      0.111719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      0.732053,
      1,
      0,
      0.387389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.847254,
      0,
      0.232139,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.746161,
      NULL,
      2,
      0.372831,
      NULL,
      NULL,
      NULL,
      0.809699,
      4.532984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1.372858,
      0.111837,
      NULL,
      3.779780,
      0,
      NULL,
      3.736064,
      0.665818,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.201602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.855942,
      '32021',
      '',
      '',
      1.846861,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      4.081577,
      NULL,
      1.056983,
      2,
      NULL,
      3,
      NULL,
      0,
      0);
commit;
end;
/


