set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '31212321',
      44,
      23,
      '1414202',
      61,
      1,
      0.910480,
      2,
      '440144',
      2,
      '11-20-1989',
      44.202044,
      9.574424,
      NULL,
      NULL,
      0.405034,
      NULL,
      NULL,
      0,
      0,
      1.441811,
      1.994451,
      1.929641,
      3.111489,
      0.261292,
      NULL,
      1,
      1.401053,
      0,
      1.719155,
      NULL,
      4,
      1,
      4.627690,
      1,
      5,
      0.848756,
      NULL,
      NULL,
      4.545346,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.075373,
      NULL,
      NULL,
      5,
      2,
      4,
      NULL,
      0.300029,
      2,
      0,
      0,
      1,
      2.413503,
      NULL,
      1.226356,
      NULL,
      3.562216,
      0.344797,
      0,
      2.908743,
      NULL,
      NULL,
      0.443717,
      4,
      3.110176,
      4.250265,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1.508314,
      NULL,
      NULL,
      0.464638,
      1,
      1.426246,
      0.953420,
      0,
      1.909123,
      1,
      0.446691,
      0,
      1.476897,
      5,
      0,
      NULL,
      NULL,
      1.264762,
      1.495276,
      1,
      0,
      1.090445,
      NULL,
      1.433054,
      NULL,
      0,
      1.811916,
      0,
      0.772096,
      0.879676,
      2.082203,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.120245,
      1,
      1.034996,
      NULL,
      NULL,
      NULL,
      1.425306,
      4,
      3.184069,
      6,
      9.901156,
      2,
      3,
      6.549622,
      0,
      NULL,
      0.607746,
      NULL,
      0.171957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      1,
      1,
      1.279564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.726266,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.012800,
      0.498152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176542,
      2.479391,
      NULL,
      3.747626,
      NULL,
      NULL,
      3.654753,
      2,
      0,
      1.993743,
      0.371997,
      NULL,
      0.309507,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '00201',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      4,
      1,
      3,
      NULL,
      1,
      1,
      0,
      0,
      2.898176);
commit;
end;
/


